/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.IOException;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.util.ArrayUtil;

public class TagTreeDecoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;

    public TagTreeDecoder(int h, int w) {
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException();
        }
        this.w = w;
        this.h = h;
        if (w == 0 || h == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (h != 1 || w != 1) {
                w = w + 1 >> 1;
                h = h + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        w = this.w;
        h = this.h;
        int i = 0;
        while (i < this.lvls) {
            this.treeV[i] = new int[h * w];
            ArrayUtil.intArraySet(this.treeV[i], Integer.MAX_VALUE);
            this.treeS[i] = new int[h * w];
            w = w + 1 >> 1;
            h = h + 1 >> 1;
            ++i;
        }
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public int update(int m, int n, int t, PktHeaderBitReader in) throws IOException {
        int tv;
        if (m >= this.h || n >= this.w || t < 0) {
            throw new IllegalArgumentException();
        }
        int k = this.lvls - 1;
        int tmin = this.treeS[k][0];
        int idx = (m >> k) * (this.w + (1 << k) - 1 >> k) + (n >> k);
        while (true) {
            int ts = this.treeS[k][idx];
            tv = this.treeV[k][idx];
            if (ts < tmin) {
                ts = tmin;
            }
            while (t > ts) {
                if (tv >= ts) {
                    if (in.readBit() == 0) {
                        ++ts;
                        continue;
                    }
                    tv = ts++;
                    continue;
                }
                ts = t;
                break;
            }
            this.treeS[k][idx] = ts;
            this.treeV[k][idx] = tv;
            if (k <= 0) break;
            tmin = ts < tv ? ts : tv;
            idx = (m >> --k) * (this.w + (1 << k) - 1 >> k) + (n >> k);
        }
        return tv;
    }

    public int getValue(int m, int n) {
        if (m >= this.h || n >= this.w) {
            throw new IllegalArgumentException();
        }
        return this.treeV[0][m * this.w + n];
    }
}

